<?php
// Exit if accessed directly
if( !defined('ABSPATH') ) exit;

/**
 * Social Login Data
 * 
 * Handles to show social login data
 * on the page
 * 
 * @package WPSocial Deals Engine
 * @since 1.0.0
 */
global $edd_slg_model, $edd_options;

//social model class
$model = $edd_slg_model; ?>

<div class="wrap">
	<h2 class="edd-slg-settings-title"><?php esc_html_e( 'Social Login', 'eddslg' ); ?></h2>
	
	<?php
	//save order of social networks
	if( isset( $_POST['edd-slg-settings-social-submit'] ) && $_POST['edd-slg-settings-social-submit'] == esc_html__('Save Changes','eddslg') ) {
		
		$edd_social_order = $_POST['social_order'];
		$edd_social_order = array_unique( $edd_social_order );
		
		update_option( 'edd_social_order', $edd_social_order );
		
		echo '<div id="message" class="updated fade below-h2">
				<p><strong>'.esc_html__( 'Changes Saved.','eddslg').'</strong></p>
			</div>';
	} ?>
	
	<form action="" method="POST">
		<h3><?php esc_html_e( 'Drag to Change Order', 'eddslg' );?></h3>
		<p><?php esc_html_e('Drag and drop the below providers to control their display order.', 'eddslg'); ?></p>
		<table class="edd-slg-sortable widefat">
			<thead>
				<tr>
					<th width="3%"></th>
					<th width="1%" class="edd-slg-social-none">
						<?php esc_html_e('Chage Order', 'eddslg'); ?>
					</th>

					<?php
					//do action to add header before
					do_action( 'edd_slg_social_table_header_order_before' ); ?>
					
					<th class="col-network"><?php esc_html_e( 'Network', 'eddslg');?></th>
					
					<?php
					//do action to add social table header network after
					do_action( 'edd_slg_social_table_header_network_before' ); ?>

					<th class="col-register-count"><?php esc_html_e( 'Register Count', 'eddslg');?></th>
					
					<?php
					//do action to add social table header after
					do_action( 'edd_slg_social_table_header_count_before' ); ?>

					<th class="col-status"><?php esc_html_e( 'Status', 'eddslg');?></th>

					<?php
					//do action to add social table header status after
					do_action( 'edd_slg_social_table_header_status_before' ); ?>
				</tr>
			</thead>
			<tbody>
				<?php
				global $edd_options;

				//do action to add social table content before
				do_action( 'edd_slg_social_table_content_before' );
				
				//get all social networks
				$allnetworks = edd_slg_get_sorted_social_network();
				
				//register user count
				$regusers = array();
				
				foreach( $allnetworks as $key => $value ) {
					
					$countargs = array( 
										'getcount' =>	'1',
										'network'	=>	$key 
									  );
					$regusers[$key]['count'] = $model->edd_slg_social_get_users( $countargs );
					$regusers[$key]['label'] = $value;

					$is_network_activated = !empty($edd_options['edd_slg_enable_'.$key]) ? $edd_options['edd_slg_enable_'.$key] : ''; ?>

					<tr>
						<?php
						//do action to add social table data before
						do_action( 'edd_slg_social_table_data_before', $key, $value ); ?>

						<td class="edd-slg-table-col">
							<img class='edd-slg-drag-drop-menu' src="<?php echo esc_url(EDD_SLG_IMG_URL).'/backend/menu.png'; ?>" title="<?php _e('Drag & Drop', 'eddslg'); ?>">
						</td>

						<td width="1%" class="edd-slg-social-none">
							<input type="hidden" name="social_order[]" value="<?php echo $key;?>" />
						</td>

						<?php
						//do action to add social icon after
						do_action( 'edd_slg_social_table_data_icon_after', $key, $value ); ?>
						
						<td class="edd-slg-netowrk-<?php echo $key; ?> edd-slg-table-col">
							<img src="<?php echo esc_url(EDD_SLG_IMG_URL).'/backend/images/'.$key.'.png';?>" alt="<?php echo $value;?>" />
						</td>
						
						<?php
						//do action to add social table data network
						do_action( 'edd_slg_social_table_data_network_after', $key, $value ); ?>
						
						<td class="edd-slg-table-col reg-count-label">
							<?php echo $regusers[$key]['count'];?>
						</td>
						
						<?php
						//do action to add social table data reg count after
						do_action( 'edd_slg_social_table_data_reg_count_after', $key, $value ); ?>

						<td class="edd-slg-table-col">
							<?php
							// Show tick if network is activated else show -
							if( !empty($is_network_activated) && $is_network_activated == '1' ) {
								echo "<img class='edd-slg-network-activated' src='" . esc_url(EDD_SLG_IMG_URL).'/backend/check-mark.png' . "' alt='" . $value . "' />";
							} else {
								esc_html_e('-', 'eddslg');
							} ?>
						</td>

						<?php
						//do action to add social table header status after
						do_action( 'edd_slg_social_table_data_status_after' ); ?>
					</tr>
				<?php	
				}
					
				//do action to add social table content after
				do_action( 'edd_slg_social_table_content_after' ); ?>
			</tbody>

			<tfoot>
				<tr>
					<th width="3%"></th>
					<th class="col-network"><?php esc_html_e( 'Network', 'eddslg');?></th>
					<th width="1%" class="edd-slg-social-none">
						<?php esc_html_e('Change Order', 'eddslg'); ?>
					</th>
					
					<?php
					//do action to add footer before
					do_action( 'edd_slg_social_table_header_order_after' ); ?>

					<?php
					//do action to add social table footer network after
					do_action( 'edd_slg_social_table_header_network_after' ); ?>

					<th class="col-register-count"><?php esc_html_e( 'Register Count', 'eddslg');?></th>
					
					<?php
					//do action to add social table footer after
					do_action( 'edd_slg_social_table_header_count_after' ); ?>

					<th class="col-status"><?php esc_html_e( 'Status', 'eddslg');?></th>
					
					<?php
					//do action to add social table header status after
					do_action( 'edd_slg_social_table_header_status_after' ); ?>
				</tr>
			</tfoot>
		</table>
		
		<?php
		//do action to add social table after
		do_action( 'edd_slg_social_data_table_after' ); ?>

		<input type="submit" id="edd-slg-settings-social-submit" name="edd-slg-settings-social-submit" class="edd-slg-social-submit button-primary" value="<?php _e('Save Changes','eddslg');?>" />
	</form><br/>

	<h3><?php esc_html_e( 'Social Networks Registeration Pie Graph', 'eddslg' );?></h3>
	<?php
	$colors = array(
		'facebook'		=>	'A200C2',
		'twitter'		=>	'46c0FB',
		'googleplus'	=>	'0083A8',
		'linkedin'		=>	'4E6CF7',
		'yahoo'			=>	'4863AE',
		'foursquare'	=>	'44A8E0',
		'vk'			=>	'4A63A3',
		'apple'			=>	'332636',
	);

	//applying filter for chart color
	$colors = apply_filters( 'edd_slg_social_chart_colors', $colors );
	
	foreach( $regusers as $key => $val ) {
		if( $val['count']== 0 ) {
			unset( $regusers[$key] );
			unset( $colors[$key] );
		}
	}

	$datarows = array();
		if( !empty($regusers) ){
  		foreach( $regusers as $key => $val ){
			$count = $val['count'];
			$datarows[] = array( $val['label'],$count);
		}
	}

	wp_localize_script('edd-slg-admin-chart-data', 'EDDSlgChart', array(
		'datarows' => $datarows,
		'title' => esc_html__('Social Networks Register Percentage', 'eddslg'),
	)); ?>

	<div id="edd_slg_social_chart_element" class="edd-slg-social-chart-container"></div><!--.edd-slg-social-chart-container-->
</div><!--wrap-->